//
//  TopScoresViewController.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 3/17/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "TopScoresViewController.h"

@interface TopScoresViewController ()

@end

@implementation TopScoresViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [self.topScores count];
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"cell";
    
    TopScoreCell *myCell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier forIndexPath:indexPath];
    
    long row = [indexPath row];
    
    RTBGame *game = [self.topScores objectAtIndex:row];
    
    myCell.playerName.text = [NSString stringWithFormat:@"%ld. %@", row+1, game.playerName];
    myCell.score.text = [self calculateElapsedFromDate:game.startDate toDate:game.endDate];
    
    return myCell;
}

- (NSString *) calculateElapsedFromDate: (NSDate *)startDate toDate: (NSDate *)endDate {
    
    NSTimeInterval interval;
    interval = [endDate timeIntervalSinceDate:startDate];
    
    unsigned int seconds = ABS((int)interval);
    unsigned int minutes = seconds/60;
    unsigned int hours = minutes/60;
    
    return [NSString stringWithFormat:@"%02u:%02u:%02u", hours, minutes%60, seconds%60];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (IBAction)backButton:(id)sender {
    [[self navigationController] popViewControllerAnimated:YES];
}
@end
